<?php
/**
 * NOTE: This class is ONLY compatible with the Square Connect PHP SDK version 3.20200528.x
 *       and that SDK was retired in June 2020 in favor of the Square PHP SDK which requires PHP 7.1+
 * 
 * NOTE: This class is inherited from code auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace SquareConnect\Model;

/**
 * CreatePaymentRequest Class Doc Comment
 *
 * @category Class
 * @package  SquareConnect
 * @author   Square Inc.
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache License v2
 * @link     https://squareup.com/developers
 */
class ZenCartConnectCreatePaymentRequest extends CreatePaymentRequest
{
    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    static $swaggerTypes = array(
        'source_id' => 'string',
        'idempotency_key' => 'string',
        'amount_money' => '\SquareConnect\Model\Money',
        'tip_money' => '\SquareConnect\Model\Money',
        'app_fee_money' => '\SquareConnect\Model\Money',
        'delay_duration' => 'string',
        'autocomplete' => 'bool',
        'order_id' => 'string',
        'customer_id' => 'string',
        'auxiliary_info' => 'array',
        'location_id' => 'string',
        'reference_id' => 'string',
        'verification_token' => 'string',
        'accept_partial_authorization' => 'bool',
        'buyer_email_address' => 'string',
        'billing_address' => '\SquareConnect\Model\Address',
        'shipping_address' => '\SquareConnect\Model\Address',
        'note' => 'string',
        'statement_description_identifier' => 'string'
    );

    /**
      * Array of attributes where the key is the local name, and the value is the original name
      * @var string[]
      */
    static $attributeMap = array(
        'source_id' => 'source_id',
        'idempotency_key' => 'idempotency_key',
        'amount_money' => 'amount_money',
        'tip_money' => 'tip_money',
        'app_fee_money' => 'app_fee_money',
        'delay_duration' => 'delay_duration',
        'autocomplete' => 'autocomplete',
        'order_id' => 'order_id',
        'customer_id' => 'customer_id',
        'auxiliary_info' => 'auxiliary_info',
        'location_id' => 'location_id',
        'reference_id' => 'reference_id',
        'verification_token' => 'verification_token',
        'accept_partial_authorization' => 'accept_partial_authorization',
        'buyer_email_address' => 'buyer_email_address',
        'billing_address' => 'billing_address',
        'shipping_address' => 'shipping_address',
        'note' => 'note',
        'statement_description_identifier' => 'statement_description_identifier'
    );

    /**
      * Array of attributes to setter functions (for deserialization of responses)
      * @var string[]
      */
    static $setters = array(
        'source_id' => 'setSourceId',
        'idempotency_key' => 'setIdempotencyKey',
        'amount_money' => 'setAmountMoney',
        'tip_money' => 'setTipMoney',
        'app_fee_money' => 'setAppFeeMoney',
        'delay_duration' => 'setDelayDuration',
        'autocomplete' => 'setAutocomplete',
        'order_id' => 'setOrderId',
        'customer_id' => 'setCustomerId',
        'auxiliary_info' => 'setAuxiliaryInfo',
        'location_id' => 'setLocationId',
        'reference_id' => 'setReferenceId',
        'verification_token' => 'setVerificationToken',
        'accept_partial_authorization' => 'setAcceptPartialAuthorization',
        'buyer_email_address' => 'setBuyerEmailAddress',
        'billing_address' => 'setBillingAddress',
        'shipping_address' => 'setShippingAddress',
        'note' => 'setNote',
        'statement_description_identifier' => 'setStatementDescriptionIdentifier'
    );

    /**
      * Array of attributes to getter functions (for serialization of requests)
      * @var string[]
      */
    static $getters = array(
        'source_id' => 'getSourceId',
        'idempotency_key' => 'getIdempotencyKey',
        'amount_money' => 'getAmountMoney',
        'tip_money' => 'getTipMoney',
        'app_fee_money' => 'getAppFeeMoney',
        'delay_duration' => 'getDelayDuration',
        'autocomplete' => 'getAutocomplete',
        'order_id' => 'getOrderId',
        'customer_id' => 'getCustomerId',
        'auxiliary_info' => 'getAuxiliaryInfo',
        'location_id' => 'getLocationId',
        'reference_id' => 'getReferenceId',
        'verification_token' => 'getVerificationToken',
        'accept_partial_authorization' => 'getAcceptPartialAuthorization',
        'buyer_email_address' => 'getBuyerEmailAddress',
        'billing_address' => 'getBillingAddress',
        'shipping_address' => 'getShippingAddress',
        'note' => 'getNote',
        'statement_description_identifier' => 'getStatementDescriptionIdentifier'
    );

    /** verified integration id
     * @var string
     */
    protected $integration_id = 'sqi_b0110fe6bf154f09805ac8b7f5f27fb4';

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initializing the model
     */
    public function __construct(array $data = null)
    {
        parent::__construct($data);

        if ($data != null) {
            if (isset($data["integration_id"])) {
                $this->integration_id = $data["integration_id"];
            }
        }
    }

    /**
     * Gets integration_id
     * @return array
     */
    public function getAuxiliaryInfo()
    {
        return array(['key' => 'integration_id', 'value' => $this->integration_id]);
    }

    /**
     * Sets integration_id
     * @param string $integration_id
     * @return $this
     */
    public function setAuxiliaryInfo($integration_id)
    {
        $this->integration_id = $integration_id;
        return $this;
    }
}
