<?php
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace SquareConnect\Model;

use \ArrayAccess;
/**
 * OrderReturnLineItemModifier Class Doc Comment
 *
 * @category Class
 * @package  SquareConnect
 * @author   Square Inc.
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache License v2
 * @link     https://squareup.com/developers
 * Note: This endpoint is in beta.
 */
class OrderReturnLineItemModifier implements ArrayAccess
{
    /**
      * Array of property to type mappings. Used for (de)serialization 
      * @var string[]
      */
    static $swaggerTypes = array(
        'uid' => 'string',
        'source_modifier_uid' => 'string',
        'catalog_object_id' => 'string',
        'name' => 'string',
        'base_price_money' => '\SquareConnect\Model\Money',
        'total_price_money' => '\SquareConnect\Model\Money'
    );
  
    /** 
      * Array of attributes where the key is the local name, and the value is the original name
      * @var string[] 
      */
    static $attributeMap = array(
        'uid' => 'uid',
        'source_modifier_uid' => 'source_modifier_uid',
        'catalog_object_id' => 'catalog_object_id',
        'name' => 'name',
        'base_price_money' => 'base_price_money',
        'total_price_money' => 'total_price_money'
    );
  
    /**
      * Array of attributes to setter functions (for deserialization of responses)
      * @var string[]
      */
    static $setters = array(
        'uid' => 'setUid',
        'source_modifier_uid' => 'setSourceModifierUid',
        'catalog_object_id' => 'setCatalogObjectId',
        'name' => 'setName',
        'base_price_money' => 'setBasePriceMoney',
        'total_price_money' => 'setTotalPriceMoney'
    );
  
    /**
      * Array of attributes to getter functions (for serialization of requests)
      * @var string[]
      */
    static $getters = array(
        'uid' => 'getUid',
        'source_modifier_uid' => 'getSourceModifierUid',
        'catalog_object_id' => 'getCatalogObjectId',
        'name' => 'getName',
        'base_price_money' => 'getBasePriceMoney',
        'total_price_money' => 'getTotalPriceMoney'
    );
  
    /**
      * $uid Unique ID that identifies the return modifier only within this order.
      * @var string
      */
    protected $uid;
    /**
      * $source_modifier_uid `uid` of the Modifier from the LineItem from the Order which contains the original sale of this line item modifier.
      * @var string
      */
    protected $source_modifier_uid;
    /**
      * $catalog_object_id The catalog object id referencing `CatalogModifier`.
      * @var string
      */
    protected $catalog_object_id;
    /**
      * $name The name of the item modifier.
      * @var string
      */
    protected $name;
    /**
      * $base_price_money The base price for the modifier.  `base_price_money` is required for ad hoc modifiers. If both `catalog_object_id` and `base_price_money` are set, `base_price_money` will override the predefined `CatalogModifier` price.
      * @var \SquareConnect\Model\Money
      */
    protected $base_price_money;
    /**
      * $total_price_money The total price of the item modifier for its line item. This is the modifier's `base_price_money` multiplied by the line item's quantity.
      * @var \SquareConnect\Model\Money
      */
    protected $total_price_money;

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initializing the model
     */
    public function __construct(array $data = null)
    {
        if ($data != null) {
            if (isset($data["uid"])) {
              $this->uid = $data["uid"];
            } else {
              $this->uid = null;
            }
            if (isset($data["source_modifier_uid"])) {
              $this->source_modifier_uid = $data["source_modifier_uid"];
            } else {
              $this->source_modifier_uid = null;
            }
            if (isset($data["catalog_object_id"])) {
              $this->catalog_object_id = $data["catalog_object_id"];
            } else {
              $this->catalog_object_id = null;
            }
            if (isset($data["name"])) {
              $this->name = $data["name"];
            } else {
              $this->name = null;
            }
            if (isset($data["base_price_money"])) {
              $this->base_price_money = $data["base_price_money"];
            } else {
              $this->base_price_money = null;
            }
            if (isset($data["total_price_money"])) {
              $this->total_price_money = $data["total_price_money"];
            } else {
              $this->total_price_money = null;
            }
        }
    }
    /**
     * Gets uid
     * @return string
     */
    public function getUid()
    {
        return $this->uid;
    }
  
    /**
     * Sets uid
     * @param string $uid Unique ID that identifies the return modifier only within this order.
     * @return $this
     */
    public function setUid($uid)
    {
        $this->uid = $uid;
        return $this;
    }
    /**
     * Gets source_modifier_uid
     * @return string
     */
    public function getSourceModifierUid()
    {
        return $this->source_modifier_uid;
    }
  
    /**
     * Sets source_modifier_uid
     * @param string $source_modifier_uid `uid` of the Modifier from the LineItem from the Order which contains the original sale of this line item modifier.
     * @return $this
     */
    public function setSourceModifierUid($source_modifier_uid)
    {
        $this->source_modifier_uid = $source_modifier_uid;
        return $this;
    }
    /**
     * Gets catalog_object_id
     * @return string
     */
    public function getCatalogObjectId()
    {
        return $this->catalog_object_id;
    }
  
    /**
     * Sets catalog_object_id
     * @param string $catalog_object_id The catalog object id referencing `CatalogModifier`.
     * @return $this
     */
    public function setCatalogObjectId($catalog_object_id)
    {
        $this->catalog_object_id = $catalog_object_id;
        return $this;
    }
    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
  
    /**
     * Sets name
     * @param string $name The name of the item modifier.
     * @return $this
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Gets base_price_money
     * @return \SquareConnect\Model\Money
     */
    public function getBasePriceMoney()
    {
        return $this->base_price_money;
    }
  
    /**
     * Sets base_price_money
     * @param \SquareConnect\Model\Money $base_price_money The base price for the modifier.  `base_price_money` is required for ad hoc modifiers. If both `catalog_object_id` and `base_price_money` are set, `base_price_money` will override the predefined `CatalogModifier` price.
     * @return $this
     */
    public function setBasePriceMoney($base_price_money)
    {
        $this->base_price_money = $base_price_money;
        return $this;
    }
    /**
     * Gets total_price_money
     * @return \SquareConnect\Model\Money
     */
    public function getTotalPriceMoney()
    {
        return $this->total_price_money;
    }
  
    /**
     * Sets total_price_money
     * @param \SquareConnect\Model\Money $total_price_money The total price of the item modifier for its line item. This is the modifier's `base_price_money` multiplied by the line item's quantity.
     * @return $this
     */
    public function setTotalPriceMoney($total_price_money)
    {
        $this->total_price_money = $total_price_money;
        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset 
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->$offset);
    }
  
    /**
     * Gets offset.
     * @param  integer $offset Offset 
     * @return mixed 
     */
    public function offsetGet($offset)
    {
        return $this->$offset;
    }
  
    /**
     * Sets value based on offset.
     * @param  integer $offset Offset 
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        $this->$offset = $value;
    }
  
    /**
     * Unsets offset.
     * @param  integer $offset Offset 
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->$offset);
    }
  
    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        } else {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this));
        }
    }
}
