<?php
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace SquareConnect\Model;

use \ArrayAccess;
/**
 * OrderFulfillment Class Doc Comment
 *
 * @category Class
 * @package  SquareConnect
 * @author   Square Inc.
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache License v2
 * @link     https://squareup.com/developers
 */
class OrderFulfillment implements ArrayAccess
{
    /**
      * Array of property to type mappings. Used for (de)serialization 
      * @var string[]
      */
    static $swaggerTypes = array(
        'uid' => 'string',
        'type' => 'string',
        'state' => 'string',
        'metadata' => 'map[string,string]',
        'pickup_details' => '\SquareConnect\Model\OrderFulfillmentPickupDetails',
        'shipment_details' => '\SquareConnect\Model\OrderFulfillmentShipmentDetails'
    );
  
    /** 
      * Array of attributes where the key is the local name, and the value is the original name
      * @var string[] 
      */
    static $attributeMap = array(
        'uid' => 'uid',
        'type' => 'type',
        'state' => 'state',
        'metadata' => 'metadata',
        'pickup_details' => 'pickup_details',
        'shipment_details' => 'shipment_details'
    );
  
    /**
      * Array of attributes to setter functions (for deserialization of responses)
      * @var string[]
      */
    static $setters = array(
        'uid' => 'setUid',
        'type' => 'setType',
        'state' => 'setState',
        'metadata' => 'setMetadata',
        'pickup_details' => 'setPickupDetails',
        'shipment_details' => 'setShipmentDetails'
    );
  
    /**
      * Array of attributes to getter functions (for serialization of requests)
      * @var string[]
      */
    static $getters = array(
        'uid' => 'getUid',
        'type' => 'getType',
        'state' => 'getState',
        'metadata' => 'getMetadata',
        'pickup_details' => 'getPickupDetails',
        'shipment_details' => 'getShipmentDetails'
    );
  
    /**
      * $uid Unique ID that identifies the fulfillment only within this order.
      * @var string
      */
    protected $uid;
    /**
      * $type The type of the fulfillment. See [OrderFulfillmentType](#type-orderfulfillmenttype) for possible values
      * @var string
      */
    protected $type;
    /**
      * $state The state of the fulfillment. See [OrderFulfillmentState](#type-orderfulfillmentstate) for possible values
      * @var string
      */
    protected $state;
    /**
      * $metadata Application-defined data attached to this fulfillment. Metadata fields are intended to store descriptive references or associations with an entity in another system or store brief information about the object. Square does not process this field; it only stores and returns it in relevant API calls. Do not use metadata to store any sensitive information (personally identifiable information, card details, etc.).  Keys written by applications must be 60 characters or less and must be in the character set `[a-zA-Z0-9_-]`. Entries may also include metadata generated by Square. These keys are prefixed with a namespace, separated from the key with a ':' character.  Values have a max length of 255 characters.  An application may have up to 10 entries per metadata field.  Entries written by applications are private and can only be read or modified by the same application.  See [Metadata](https://developer.squareup.com/docs/build-basics/metadata) for more information.
      * @var map[string,string]
      */
    protected $metadata;
    /**
      * $pickup_details Contains details for a pickup fulfillment. Required when fulfillment type is `PICKUP`.
      * @var \SquareConnect\Model\OrderFulfillmentPickupDetails
      */
    protected $pickup_details;
    /**
      * $shipment_details Contains details for a shipment fulfillment. Required when fulfillment type is `SHIPMENT`.  A shipment fulfillment's relationship to fulfillment `state`: `PROPOSED`: A shipment is requested. `RESERVED`: Fulfillment accepted. Shipment processing. `PREPARED`: Shipment packaged. Shipping label created. `COMPLETED`: Package has been shipped. `CANCELED`: Shipment has been canceled. `FAILED`: Shipment has failed.
      * @var \SquareConnect\Model\OrderFulfillmentShipmentDetails
      */
    protected $shipment_details;

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initializing the model
     */
    public function __construct(array $data = null)
    {
        if ($data != null) {
            if (isset($data["uid"])) {
              $this->uid = $data["uid"];
            } else {
              $this->uid = null;
            }
            if (isset($data["type"])) {
              $this->type = $data["type"];
            } else {
              $this->type = null;
            }
            if (isset($data["state"])) {
              $this->state = $data["state"];
            } else {
              $this->state = null;
            }
            if (isset($data["metadata"])) {
              $this->metadata = $data["metadata"];
            } else {
              $this->metadata = null;
            }
            if (isset($data["pickup_details"])) {
              $this->pickup_details = $data["pickup_details"];
            } else {
              $this->pickup_details = null;
            }
            if (isset($data["shipment_details"])) {
              $this->shipment_details = $data["shipment_details"];
            } else {
              $this->shipment_details = null;
            }
        }
    }
    /**
     * Gets uid
     * @return string
     */
    public function getUid()
    {
        return $this->uid;
    }
  
    /**
     * Sets uid
     * @param string $uid Unique ID that identifies the fulfillment only within this order.
     * @return $this
     */
    public function setUid($uid)
    {
        $this->uid = $uid;
        return $this;
    }
    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
  
    /**
     * Sets type
     * @param string $type The type of the fulfillment. See [OrderFulfillmentType](#type-orderfulfillmenttype) for possible values
     * @return $this
     */
    public function setType($type)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->state;
    }
  
    /**
     * Sets state
     * @param string $state The state of the fulfillment. See [OrderFulfillmentState](#type-orderfulfillmentstate) for possible values
     * @return $this
     */
    public function setState($state)
    {
        $this->state = $state;
        return $this;
    }
    /**
     * Gets metadata
     * @return map[string,string]
     */
    public function getMetadata()
    {
        return $this->metadata;
    }
  
    /**
     * Sets metadata
     * @param map[string,string] $metadata Application-defined data attached to this fulfillment. Metadata fields are intended to store descriptive references or associations with an entity in another system or store brief information about the object. Square does not process this field; it only stores and returns it in relevant API calls. Do not use metadata to store any sensitive information (personally identifiable information, card details, etc.).  Keys written by applications must be 60 characters or less and must be in the character set `[a-zA-Z0-9_-]`. Entries may also include metadata generated by Square. These keys are prefixed with a namespace, separated from the key with a ':' character.  Values have a max length of 255 characters.  An application may have up to 10 entries per metadata field.  Entries written by applications are private and can only be read or modified by the same application.  See [Metadata](https://developer.squareup.com/docs/build-basics/metadata) for more information.
     * @return $this
     */
    public function setMetadata($metadata)
    {
        $this->metadata = $metadata;
        return $this;
    }
    /**
     * Gets pickup_details
     * @return \SquareConnect\Model\OrderFulfillmentPickupDetails
     */
    public function getPickupDetails()
    {
        return $this->pickup_details;
    }
  
    /**
     * Sets pickup_details
     * @param \SquareConnect\Model\OrderFulfillmentPickupDetails $pickup_details Contains details for a pickup fulfillment. Required when fulfillment type is `PICKUP`.
     * @return $this
     */
    public function setPickupDetails($pickup_details)
    {
        $this->pickup_details = $pickup_details;
        return $this;
    }
    /**
     * Gets shipment_details
     * @return \SquareConnect\Model\OrderFulfillmentShipmentDetails
     */
    public function getShipmentDetails()
    {
        return $this->shipment_details;
    }
  
    /**
     * Sets shipment_details
     * @param \SquareConnect\Model\OrderFulfillmentShipmentDetails $shipment_details Contains details for a shipment fulfillment. Required when fulfillment type is `SHIPMENT`.  A shipment fulfillment's relationship to fulfillment `state`: `PROPOSED`: A shipment is requested. `RESERVED`: Fulfillment accepted. Shipment processing. `PREPARED`: Shipment packaged. Shipping label created. `COMPLETED`: Package has been shipped. `CANCELED`: Shipment has been canceled. `FAILED`: Shipment has failed.
     * @return $this
     */
    public function setShipmentDetails($shipment_details)
    {
        $this->shipment_details = $shipment_details;
        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset 
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->$offset);
    }
  
    /**
     * Gets offset.
     * @param  integer $offset Offset 
     * @return mixed 
     */
    public function offsetGet($offset)
    {
        return $this->$offset;
    }
  
    /**
     * Sets value based on offset.
     * @param  integer $offset Offset 
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        $this->$offset = $value;
    }
  
    /**
     * Unsets offset.
     * @param  integer $offset Offset 
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->$offset);
    }
  
    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        } else {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this));
        }
    }
}
