<?php
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace SquareConnect\Model;

use \ArrayAccess;
/**
 * LoyaltyEvent Class Doc Comment
 *
 * @category Class
 * @package  SquareConnect
 * @author   Square Inc.
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache License v2
 * @link     https://squareup.com/developers
 * Note: This endpoint is in beta.
 */
class LoyaltyEvent implements ArrayAccess
{
    /**
      * Array of property to type mappings. Used for (de)serialization 
      * @var string[]
      */
    static $swaggerTypes = array(
        'id' => 'string',
        'type' => 'string',
        'created_at' => 'string',
        'accumulate_points' => '\SquareConnect\Model\LoyaltyEventAccumulatePoints',
        'create_reward' => '\SquareConnect\Model\LoyaltyEventCreateReward',
        'redeem_reward' => '\SquareConnect\Model\LoyaltyEventRedeemReward',
        'delete_reward' => '\SquareConnect\Model\LoyaltyEventDeleteReward',
        'adjust_points' => '\SquareConnect\Model\LoyaltyEventAdjustPoints',
        'loyalty_account_id' => 'string',
        'location_id' => 'string',
        'source' => 'string',
        'expire_points' => '\SquareConnect\Model\LoyaltyEventExpirePoints',
        'other_event' => '\SquareConnect\Model\LoyaltyEventOther'
    );
  
    /** 
      * Array of attributes where the key is the local name, and the value is the original name
      * @var string[] 
      */
    static $attributeMap = array(
        'id' => 'id',
        'type' => 'type',
        'created_at' => 'created_at',
        'accumulate_points' => 'accumulate_points',
        'create_reward' => 'create_reward',
        'redeem_reward' => 'redeem_reward',
        'delete_reward' => 'delete_reward',
        'adjust_points' => 'adjust_points',
        'loyalty_account_id' => 'loyalty_account_id',
        'location_id' => 'location_id',
        'source' => 'source',
        'expire_points' => 'expire_points',
        'other_event' => 'other_event'
    );
  
    /**
      * Array of attributes to setter functions (for deserialization of responses)
      * @var string[]
      */
    static $setters = array(
        'id' => 'setId',
        'type' => 'setType',
        'created_at' => 'setCreatedAt',
        'accumulate_points' => 'setAccumulatePoints',
        'create_reward' => 'setCreateReward',
        'redeem_reward' => 'setRedeemReward',
        'delete_reward' => 'setDeleteReward',
        'adjust_points' => 'setAdjustPoints',
        'loyalty_account_id' => 'setLoyaltyAccountId',
        'location_id' => 'setLocationId',
        'source' => 'setSource',
        'expire_points' => 'setExpirePoints',
        'other_event' => 'setOtherEvent'
    );
  
    /**
      * Array of attributes to getter functions (for serialization of requests)
      * @var string[]
      */
    static $getters = array(
        'id' => 'getId',
        'type' => 'getType',
        'created_at' => 'getCreatedAt',
        'accumulate_points' => 'getAccumulatePoints',
        'create_reward' => 'getCreateReward',
        'redeem_reward' => 'getRedeemReward',
        'delete_reward' => 'getDeleteReward',
        'adjust_points' => 'getAdjustPoints',
        'loyalty_account_id' => 'getLoyaltyAccountId',
        'location_id' => 'getLocationId',
        'source' => 'getSource',
        'expire_points' => 'getExpirePoints',
        'other_event' => 'getOtherEvent'
    );
  
    /**
      * $id The Square-assigned ID of the loyalty event.
      * @var string
      */
    protected $id;
    /**
      * $type The type of the loyalty event. See [LoyaltyEventType](#type-loyaltyeventtype) for possible values
      * @var string
      */
    protected $type;
    /**
      * $created_at The timestamp when the event was created, in RFC 3339 format.
      * @var string
      */
    protected $created_at;
    /**
      * $accumulate_points Provides metadata when the event `type` is `ACCUMULATE_POINTS`.
      * @var \SquareConnect\Model\LoyaltyEventAccumulatePoints
      */
    protected $accumulate_points;
    /**
      * $create_reward Provides metadata when the event `type` is `CREATE_REWARD`.
      * @var \SquareConnect\Model\LoyaltyEventCreateReward
      */
    protected $create_reward;
    /**
      * $redeem_reward Provides metadata when the event `type` is `REDEEM_REWARD`.
      * @var \SquareConnect\Model\LoyaltyEventRedeemReward
      */
    protected $redeem_reward;
    /**
      * $delete_reward Provides metadata when the event `type` is `DELETE_REWARD`.
      * @var \SquareConnect\Model\LoyaltyEventDeleteReward
      */
    protected $delete_reward;
    /**
      * $adjust_points Provides metadata when the event `type` is `ADJUST_POINTS`.
      * @var \SquareConnect\Model\LoyaltyEventAdjustPoints
      */
    protected $adjust_points;
    /**
      * $loyalty_account_id The ID of the `loyalty account` in which the event occurred.
      * @var string
      */
    protected $loyalty_account_id;
    /**
      * $location_id The ID of the `location` where the event occurred.
      * @var string
      */
    protected $location_id;
    /**
      * $source Defines whether the event was generated by the Square Point of Sale. See [LoyaltyEventSource](#type-loyaltyeventsource) for possible values
      * @var string
      */
    protected $source;
    /**
      * $expire_points Provides metadata when the event `type` is `EXPIRE_POINTS`.
      * @var \SquareConnect\Model\LoyaltyEventExpirePoints
      */
    protected $expire_points;
    /**
      * $other_event Provides metadata when the event `type` is `OTHER`.
      * @var \SquareConnect\Model\LoyaltyEventOther
      */
    protected $other_event;

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initializing the model
     */
    public function __construct(array $data = null)
    {
        if ($data != null) {
            if (isset($data["id"])) {
              $this->id = $data["id"];
            } else {
              $this->id = null;
            }
            if (isset($data["type"])) {
              $this->type = $data["type"];
            } else {
              $this->type = null;
            }
            if (isset($data["created_at"])) {
              $this->created_at = $data["created_at"];
            } else {
              $this->created_at = null;
            }
            if (isset($data["accumulate_points"])) {
              $this->accumulate_points = $data["accumulate_points"];
            } else {
              $this->accumulate_points = null;
            }
            if (isset($data["create_reward"])) {
              $this->create_reward = $data["create_reward"];
            } else {
              $this->create_reward = null;
            }
            if (isset($data["redeem_reward"])) {
              $this->redeem_reward = $data["redeem_reward"];
            } else {
              $this->redeem_reward = null;
            }
            if (isset($data["delete_reward"])) {
              $this->delete_reward = $data["delete_reward"];
            } else {
              $this->delete_reward = null;
            }
            if (isset($data["adjust_points"])) {
              $this->adjust_points = $data["adjust_points"];
            } else {
              $this->adjust_points = null;
            }
            if (isset($data["loyalty_account_id"])) {
              $this->loyalty_account_id = $data["loyalty_account_id"];
            } else {
              $this->loyalty_account_id = null;
            }
            if (isset($data["location_id"])) {
              $this->location_id = $data["location_id"];
            } else {
              $this->location_id = null;
            }
            if (isset($data["source"])) {
              $this->source = $data["source"];
            } else {
              $this->source = null;
            }
            if (isset($data["expire_points"])) {
              $this->expire_points = $data["expire_points"];
            } else {
              $this->expire_points = null;
            }
            if (isset($data["other_event"])) {
              $this->other_event = $data["other_event"];
            } else {
              $this->other_event = null;
            }
        }
    }
    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
  
    /**
     * Sets id
     * @param string $id The Square-assigned ID of the loyalty event.
     * @return $this
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
  
    /**
     * Sets type
     * @param string $type The type of the loyalty event. See [LoyaltyEventType](#type-loyaltyeventtype) for possible values
     * @return $this
     */
    public function setType($type)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Gets created_at
     * @return string
     */
    public function getCreatedAt()
    {
        return $this->created_at;
    }
  
    /**
     * Sets created_at
     * @param string $created_at The timestamp when the event was created, in RFC 3339 format.
     * @return $this
     */
    public function setCreatedAt($created_at)
    {
        $this->created_at = $created_at;
        return $this;
    }
    /**
     * Gets accumulate_points
     * @return \SquareConnect\Model\LoyaltyEventAccumulatePoints
     */
    public function getAccumulatePoints()
    {
        return $this->accumulate_points;
    }
  
    /**
     * Sets accumulate_points
     * @param \SquareConnect\Model\LoyaltyEventAccumulatePoints $accumulate_points Provides metadata when the event `type` is `ACCUMULATE_POINTS`.
     * @return $this
     */
    public function setAccumulatePoints($accumulate_points)
    {
        $this->accumulate_points = $accumulate_points;
        return $this;
    }
    /**
     * Gets create_reward
     * @return \SquareConnect\Model\LoyaltyEventCreateReward
     */
    public function getCreateReward()
    {
        return $this->create_reward;
    }
  
    /**
     * Sets create_reward
     * @param \SquareConnect\Model\LoyaltyEventCreateReward $create_reward Provides metadata when the event `type` is `CREATE_REWARD`.
     * @return $this
     */
    public function setCreateReward($create_reward)
    {
        $this->create_reward = $create_reward;
        return $this;
    }
    /**
     * Gets redeem_reward
     * @return \SquareConnect\Model\LoyaltyEventRedeemReward
     */
    public function getRedeemReward()
    {
        return $this->redeem_reward;
    }
  
    /**
     * Sets redeem_reward
     * @param \SquareConnect\Model\LoyaltyEventRedeemReward $redeem_reward Provides metadata when the event `type` is `REDEEM_REWARD`.
     * @return $this
     */
    public function setRedeemReward($redeem_reward)
    {
        $this->redeem_reward = $redeem_reward;
        return $this;
    }
    /**
     * Gets delete_reward
     * @return \SquareConnect\Model\LoyaltyEventDeleteReward
     */
    public function getDeleteReward()
    {
        return $this->delete_reward;
    }
  
    /**
     * Sets delete_reward
     * @param \SquareConnect\Model\LoyaltyEventDeleteReward $delete_reward Provides metadata when the event `type` is `DELETE_REWARD`.
     * @return $this
     */
    public function setDeleteReward($delete_reward)
    {
        $this->delete_reward = $delete_reward;
        return $this;
    }
    /**
     * Gets adjust_points
     * @return \SquareConnect\Model\LoyaltyEventAdjustPoints
     */
    public function getAdjustPoints()
    {
        return $this->adjust_points;
    }
  
    /**
     * Sets adjust_points
     * @param \SquareConnect\Model\LoyaltyEventAdjustPoints $adjust_points Provides metadata when the event `type` is `ADJUST_POINTS`.
     * @return $this
     */
    public function setAdjustPoints($adjust_points)
    {
        $this->adjust_points = $adjust_points;
        return $this;
    }
    /**
     * Gets loyalty_account_id
     * @return string
     */
    public function getLoyaltyAccountId()
    {
        return $this->loyalty_account_id;
    }
  
    /**
     * Sets loyalty_account_id
     * @param string $loyalty_account_id The ID of the `loyalty account` in which the event occurred.
     * @return $this
     */
    public function setLoyaltyAccountId($loyalty_account_id)
    {
        $this->loyalty_account_id = $loyalty_account_id;
        return $this;
    }
    /**
     * Gets location_id
     * @return string
     */
    public function getLocationId()
    {
        return $this->location_id;
    }
  
    /**
     * Sets location_id
     * @param string $location_id The ID of the `location` where the event occurred.
     * @return $this
     */
    public function setLocationId($location_id)
    {
        $this->location_id = $location_id;
        return $this;
    }
    /**
     * Gets source
     * @return string
     */
    public function getSource()
    {
        return $this->source;
    }
  
    /**
     * Sets source
     * @param string $source Defines whether the event was generated by the Square Point of Sale. See [LoyaltyEventSource](#type-loyaltyeventsource) for possible values
     * @return $this
     */
    public function setSource($source)
    {
        $this->source = $source;
        return $this;
    }
    /**
     * Gets expire_points
     * @return \SquareConnect\Model\LoyaltyEventExpirePoints
     */
    public function getExpirePoints()
    {
        return $this->expire_points;
    }
  
    /**
     * Sets expire_points
     * @param \SquareConnect\Model\LoyaltyEventExpirePoints $expire_points Provides metadata when the event `type` is `EXPIRE_POINTS`.
     * @return $this
     */
    public function setExpirePoints($expire_points)
    {
        $this->expire_points = $expire_points;
        return $this;
    }
    /**
     * Gets other_event
     * @return \SquareConnect\Model\LoyaltyEventOther
     */
    public function getOtherEvent()
    {
        return $this->other_event;
    }
  
    /**
     * Sets other_event
     * @param \SquareConnect\Model\LoyaltyEventOther $other_event Provides metadata when the event `type` is `OTHER`.
     * @return $this
     */
    public function setOtherEvent($other_event)
    {
        $this->other_event = $other_event;
        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset 
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->$offset);
    }
  
    /**
     * Gets offset.
     * @param  integer $offset Offset 
     * @return mixed 
     */
    public function offsetGet($offset)
    {
        return $this->$offset;
    }
  
    /**
     * Sets value based on offset.
     * @param  integer $offset Offset 
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        $this->$offset = $value;
    }
  
    /**
     * Unsets offset.
     * @param  integer $offset Offset 
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->$offset);
    }
  
    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        } else {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this));
        }
    }
}
