<?php
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace SquareConnect\Model;

use \ArrayAccess;
/**
 * LoyaltyAccount Class Doc Comment
 *
 * @category Class
 * @package  SquareConnect
 * @author   Square Inc.
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache License v2
 * @link     https://squareup.com/developers
 * Note: This endpoint is in beta.
 */
class LoyaltyAccount implements ArrayAccess
{
    /**
      * Array of property to type mappings. Used for (de)serialization 
      * @var string[]
      */
    static $swaggerTypes = array(
        'id' => 'string',
        'mappings' => '\SquareConnect\Model\LoyaltyAccountMapping[]',
        'program_id' => 'string',
        'balance' => 'int',
        'lifetime_points' => 'int',
        'customer_id' => 'string',
        'enrolled_at' => 'string',
        'created_at' => 'string',
        'updated_at' => 'string'
    );
  
    /** 
      * Array of attributes where the key is the local name, and the value is the original name
      * @var string[] 
      */
    static $attributeMap = array(
        'id' => 'id',
        'mappings' => 'mappings',
        'program_id' => 'program_id',
        'balance' => 'balance',
        'lifetime_points' => 'lifetime_points',
        'customer_id' => 'customer_id',
        'enrolled_at' => 'enrolled_at',
        'created_at' => 'created_at',
        'updated_at' => 'updated_at'
    );
  
    /**
      * Array of attributes to setter functions (for deserialization of responses)
      * @var string[]
      */
    static $setters = array(
        'id' => 'setId',
        'mappings' => 'setMappings',
        'program_id' => 'setProgramId',
        'balance' => 'setBalance',
        'lifetime_points' => 'setLifetimePoints',
        'customer_id' => 'setCustomerId',
        'enrolled_at' => 'setEnrolledAt',
        'created_at' => 'setCreatedAt',
        'updated_at' => 'setUpdatedAt'
    );
  
    /**
      * Array of attributes to getter functions (for serialization of requests)
      * @var string[]
      */
    static $getters = array(
        'id' => 'getId',
        'mappings' => 'getMappings',
        'program_id' => 'getProgramId',
        'balance' => 'getBalance',
        'lifetime_points' => 'getLifetimePoints',
        'customer_id' => 'getCustomerId',
        'enrolled_at' => 'getEnrolledAt',
        'created_at' => 'getCreatedAt',
        'updated_at' => 'getUpdatedAt'
    );
  
    /**
      * $id The Square-assigned ID of the loyalty account.
      * @var string
      */
    protected $id;
    /**
      * $mappings The list of mappings that the account is associated with.  Currently, a buyer can only be mapped to a loyalty account using  a phone number. Therefore, the list can only have one mapping.
      * @var \SquareConnect\Model\LoyaltyAccountMapping[]
      */
    protected $mappings;
    /**
      * $program_id The Square-assigned ID of the `loyalty program` to which the account belongs.
      * @var string
      */
    protected $program_id;
    /**
      * $balance The available point balance in the loyalty account.
      * @var int
      */
    protected $balance;
    /**
      * $lifetime_points The total points accrued during the lifetime of the account.
      * @var int
      */
    protected $lifetime_points;
    /**
      * $customer_id The Square-assigned ID of the `customer` that is associated with the account.
      * @var string
      */
    protected $customer_id;
    /**
      * $enrolled_at The timestamp when enrollment occurred, in RFC 3339 format.
      * @var string
      */
    protected $enrolled_at;
    /**
      * $created_at The timestamp when the loyalty account was created, in RFC 3339 format.
      * @var string
      */
    protected $created_at;
    /**
      * $updated_at The timestamp when the loyalty account was last updated, in RFC 3339 format.
      * @var string
      */
    protected $updated_at;

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initializing the model
     */
    public function __construct(array $data = null)
    {
        if ($data != null) {
            if (isset($data["id"])) {
              $this->id = $data["id"];
            } else {
              $this->id = null;
            }
            if (isset($data["mappings"])) {
              $this->mappings = $data["mappings"];
            } else {
              $this->mappings = null;
            }
            if (isset($data["program_id"])) {
              $this->program_id = $data["program_id"];
            } else {
              $this->program_id = null;
            }
            if (isset($data["balance"])) {
              $this->balance = $data["balance"];
            } else {
              $this->balance = null;
            }
            if (isset($data["lifetime_points"])) {
              $this->lifetime_points = $data["lifetime_points"];
            } else {
              $this->lifetime_points = null;
            }
            if (isset($data["customer_id"])) {
              $this->customer_id = $data["customer_id"];
            } else {
              $this->customer_id = null;
            }
            if (isset($data["enrolled_at"])) {
              $this->enrolled_at = $data["enrolled_at"];
            } else {
              $this->enrolled_at = null;
            }
            if (isset($data["created_at"])) {
              $this->created_at = $data["created_at"];
            } else {
              $this->created_at = null;
            }
            if (isset($data["updated_at"])) {
              $this->updated_at = $data["updated_at"];
            } else {
              $this->updated_at = null;
            }
        }
    }
    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
  
    /**
     * Sets id
     * @param string $id The Square-assigned ID of the loyalty account.
     * @return $this
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Gets mappings
     * @return \SquareConnect\Model\LoyaltyAccountMapping[]
     */
    public function getMappings()
    {
        return $this->mappings;
    }
  
    /**
     * Sets mappings
     * @param \SquareConnect\Model\LoyaltyAccountMapping[] $mappings The list of mappings that the account is associated with.  Currently, a buyer can only be mapped to a loyalty account using  a phone number. Therefore, the list can only have one mapping.
     * @return $this
     */
    public function setMappings($mappings)
    {
        $this->mappings = $mappings;
        return $this;
    }
    /**
     * Gets program_id
     * @return string
     */
    public function getProgramId()
    {
        return $this->program_id;
    }
  
    /**
     * Sets program_id
     * @param string $program_id The Square-assigned ID of the `loyalty program` to which the account belongs.
     * @return $this
     */
    public function setProgramId($program_id)
    {
        $this->program_id = $program_id;
        return $this;
    }
    /**
     * Gets balance
     * @return int
     */
    public function getBalance()
    {
        return $this->balance;
    }
  
    /**
     * Sets balance
     * @param int $balance The available point balance in the loyalty account.
     * @return $this
     */
    public function setBalance($balance)
    {
        $this->balance = $balance;
        return $this;
    }
    /**
     * Gets lifetime_points
     * @return int
     */
    public function getLifetimePoints()
    {
        return $this->lifetime_points;
    }
  
    /**
     * Sets lifetime_points
     * @param int $lifetime_points The total points accrued during the lifetime of the account.
     * @return $this
     */
    public function setLifetimePoints($lifetime_points)
    {
        $this->lifetime_points = $lifetime_points;
        return $this;
    }
    /**
     * Gets customer_id
     * @return string
     */
    public function getCustomerId()
    {
        return $this->customer_id;
    }
  
    /**
     * Sets customer_id
     * @param string $customer_id The Square-assigned ID of the `customer` that is associated with the account.
     * @return $this
     */
    public function setCustomerId($customer_id)
    {
        $this->customer_id = $customer_id;
        return $this;
    }
    /**
     * Gets enrolled_at
     * @return string
     */
    public function getEnrolledAt()
    {
        return $this->enrolled_at;
    }
  
    /**
     * Sets enrolled_at
     * @param string $enrolled_at The timestamp when enrollment occurred, in RFC 3339 format.
     * @return $this
     */
    public function setEnrolledAt($enrolled_at)
    {
        $this->enrolled_at = $enrolled_at;
        return $this;
    }
    /**
     * Gets created_at
     * @return string
     */
    public function getCreatedAt()
    {
        return $this->created_at;
    }
  
    /**
     * Sets created_at
     * @param string $created_at The timestamp when the loyalty account was created, in RFC 3339 format.
     * @return $this
     */
    public function setCreatedAt($created_at)
    {
        $this->created_at = $created_at;
        return $this;
    }
    /**
     * Gets updated_at
     * @return string
     */
    public function getUpdatedAt()
    {
        return $this->updated_at;
    }
  
    /**
     * Sets updated_at
     * @param string $updated_at The timestamp when the loyalty account was last updated, in RFC 3339 format.
     * @return $this
     */
    public function setUpdatedAt($updated_at)
    {
        $this->updated_at = $updated_at;
        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset 
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->$offset);
    }
  
    /**
     * Gets offset.
     * @param  integer $offset Offset 
     * @return mixed 
     */
    public function offsetGet($offset)
    {
        return $this->$offset;
    }
  
    /**
     * Sets value based on offset.
     * @param  integer $offset Offset 
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        $this->$offset = $value;
    }
  
    /**
     * Unsets offset.
     * @param  integer $offset Offset 
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->$offset);
    }
  
    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        } else {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this));
        }
    }
}
