<?php
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace SquareConnect\Model;

use \ArrayAccess;
/**
 * CatalogQueryFilteredItems Class Doc Comment
 *
 * @category Class
 * @package  SquareConnect
 * @author   Square Inc.
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache License v2
 * @link     https://squareup.com/developers
 */
class CatalogQueryFilteredItems implements ArrayAccess
{
    /**
      * Array of property to type mappings. Used for (de)serialization 
      * @var string[]
      */
    static $swaggerTypes = array(
        'text_filter' => 'string',
        'search_vendor_code' => 'bool',
        'category_ids' => 'string[]',
        'stock_levels' => 'string[]',
        'enabled_location_ids' => 'string[]',
        'vendor_ids' => 'string[]',
        'product_types' => 'string[]',
        'custom_attribute_filters' => '\SquareConnect\Model\CatalogQueryFilteredItemsCustomAttributeFilter[]',
        'does_not_exist' => 'string[]',
        'sort_order' => 'string'
    );
  
    /** 
      * Array of attributes where the key is the local name, and the value is the original name
      * @var string[] 
      */
    static $attributeMap = array(
        'text_filter' => 'text_filter',
        'search_vendor_code' => 'search_vendor_code',
        'category_ids' => 'category_ids',
        'stock_levels' => 'stock_levels',
        'enabled_location_ids' => 'enabled_location_ids',
        'vendor_ids' => 'vendor_ids',
        'product_types' => 'product_types',
        'custom_attribute_filters' => 'custom_attribute_filters',
        'does_not_exist' => 'does_not_exist',
        'sort_order' => 'sort_order'
    );
  
    /**
      * Array of attributes to setter functions (for deserialization of responses)
      * @var string[]
      */
    static $setters = array(
        'text_filter' => 'setTextFilter',
        'search_vendor_code' => 'setSearchVendorCode',
        'category_ids' => 'setCategoryIds',
        'stock_levels' => 'setStockLevels',
        'enabled_location_ids' => 'setEnabledLocationIds',
        'vendor_ids' => 'setVendorIds',
        'product_types' => 'setProductTypes',
        'custom_attribute_filters' => 'setCustomAttributeFilters',
        'does_not_exist' => 'setDoesNotExist',
        'sort_order' => 'setSortOrder'
    );
  
    /**
      * Array of attributes to getter functions (for serialization of requests)
      * @var string[]
      */
    static $getters = array(
        'text_filter' => 'getTextFilter',
        'search_vendor_code' => 'getSearchVendorCode',
        'category_ids' => 'getCategoryIds',
        'stock_levels' => 'getStockLevels',
        'enabled_location_ids' => 'getEnabledLocationIds',
        'vendor_ids' => 'getVendorIds',
        'product_types' => 'getProductTypes',
        'custom_attribute_filters' => 'getCustomAttributeFilters',
        'does_not_exist' => 'getDoesNotExist',
        'sort_order' => 'getSortOrder'
    );
  
    /**
      * $text_filter 
      * @var string
      */
    protected $text_filter;
    /**
      * $search_vendor_code 
      * @var bool
      */
    protected $search_vendor_code;
    /**
      * $category_ids 
      * @var string[]
      */
    protected $category_ids;
    /**
      * $stock_levels See [CatalogQueryFilteredItemsStockLevel](#type-catalogqueryfiltereditemsstocklevel) for possible values
      * @var string[]
      */
    protected $stock_levels;
    /**
      * $enabled_location_ids 
      * @var string[]
      */
    protected $enabled_location_ids;
    /**
      * $vendor_ids 
      * @var string[]
      */
    protected $vendor_ids;
    /**
      * $product_types See [CatalogItemProductType](#type-catalogitemproducttype) for possible values
      * @var string[]
      */
    protected $product_types;
    /**
      * $custom_attribute_filters 
      * @var \SquareConnect\Model\CatalogQueryFilteredItemsCustomAttributeFilter[]
      */
    protected $custom_attribute_filters;
    /**
      * $does_not_exist See [CatalogQueryFilteredItemsNullableAttribute](#type-catalogqueryfiltereditemsnullableattribute) for possible values
      * @var string[]
      */
    protected $does_not_exist;
    /**
      * $sort_order See [SortOrder](#type-sortorder) for possible values
      * @var string
      */
    protected $sort_order;

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initializing the model
     */
    public function __construct(array $data = null)
    {
        if ($data != null) {
            if (isset($data["text_filter"])) {
              $this->text_filter = $data["text_filter"];
            } else {
              $this->text_filter = null;
            }
            if (isset($data["search_vendor_code"])) {
              $this->search_vendor_code = $data["search_vendor_code"];
            } else {
              $this->search_vendor_code = null;
            }
            if (isset($data["category_ids"])) {
              $this->category_ids = $data["category_ids"];
            } else {
              $this->category_ids = null;
            }
            if (isset($data["stock_levels"])) {
              $this->stock_levels = $data["stock_levels"];
            } else {
              $this->stock_levels = null;
            }
            if (isset($data["enabled_location_ids"])) {
              $this->enabled_location_ids = $data["enabled_location_ids"];
            } else {
              $this->enabled_location_ids = null;
            }
            if (isset($data["vendor_ids"])) {
              $this->vendor_ids = $data["vendor_ids"];
            } else {
              $this->vendor_ids = null;
            }
            if (isset($data["product_types"])) {
              $this->product_types = $data["product_types"];
            } else {
              $this->product_types = null;
            }
            if (isset($data["custom_attribute_filters"])) {
              $this->custom_attribute_filters = $data["custom_attribute_filters"];
            } else {
              $this->custom_attribute_filters = null;
            }
            if (isset($data["does_not_exist"])) {
              $this->does_not_exist = $data["does_not_exist"];
            } else {
              $this->does_not_exist = null;
            }
            if (isset($data["sort_order"])) {
              $this->sort_order = $data["sort_order"];
            } else {
              $this->sort_order = null;
            }
        }
    }
    /**
     * Gets text_filter
     * @return string
     */
    public function getTextFilter()
    {
        return $this->text_filter;
    }
  
    /**
     * Sets text_filter
     * @param string $text_filter 
     * @return $this
     */
    public function setTextFilter($text_filter)
    {
        $this->text_filter = $text_filter;
        return $this;
    }
    /**
     * Gets search_vendor_code
     * @return bool
     */
    public function getSearchVendorCode()
    {
        return $this->search_vendor_code;
    }
  
    /**
     * Sets search_vendor_code
     * @param bool $search_vendor_code 
     * @return $this
     */
    public function setSearchVendorCode($search_vendor_code)
    {
        $this->search_vendor_code = $search_vendor_code;
        return $this;
    }
    /**
     * Gets category_ids
     * @return string[]
     */
    public function getCategoryIds()
    {
        return $this->category_ids;
    }
  
    /**
     * Sets category_ids
     * @param string[] $category_ids 
     * @return $this
     */
    public function setCategoryIds($category_ids)
    {
        $this->category_ids = $category_ids;
        return $this;
    }
    /**
     * Gets stock_levels
     * @return string[]
     */
    public function getStockLevels()
    {
        return $this->stock_levels;
    }
  
    /**
     * Sets stock_levels
     * @param string[] $stock_levels See [CatalogQueryFilteredItemsStockLevel](#type-catalogqueryfiltereditemsstocklevel) for possible values
     * @return $this
     */
    public function setStockLevels($stock_levels)
    {
        $this->stock_levels = $stock_levels;
        return $this;
    }
    /**
     * Gets enabled_location_ids
     * @return string[]
     */
    public function getEnabledLocationIds()
    {
        return $this->enabled_location_ids;
    }
  
    /**
     * Sets enabled_location_ids
     * @param string[] $enabled_location_ids 
     * @return $this
     */
    public function setEnabledLocationIds($enabled_location_ids)
    {
        $this->enabled_location_ids = $enabled_location_ids;
        return $this;
    }
    /**
     * Gets vendor_ids
     * @return string[]
     */
    public function getVendorIds()
    {
        return $this->vendor_ids;
    }
  
    /**
     * Sets vendor_ids
     * @param string[] $vendor_ids 
     * @return $this
     */
    public function setVendorIds($vendor_ids)
    {
        $this->vendor_ids = $vendor_ids;
        return $this;
    }
    /**
     * Gets product_types
     * @return string[]
     */
    public function getProductTypes()
    {
        return $this->product_types;
    }
  
    /**
     * Sets product_types
     * @param string[] $product_types See [CatalogItemProductType](#type-catalogitemproducttype) for possible values
     * @return $this
     */
    public function setProductTypes($product_types)
    {
        $this->product_types = $product_types;
        return $this;
    }
    /**
     * Gets custom_attribute_filters
     * @return \SquareConnect\Model\CatalogQueryFilteredItemsCustomAttributeFilter[]
     */
    public function getCustomAttributeFilters()
    {
        return $this->custom_attribute_filters;
    }
  
    /**
     * Sets custom_attribute_filters
     * @param \SquareConnect\Model\CatalogQueryFilteredItemsCustomAttributeFilter[] $custom_attribute_filters 
     * @return $this
     */
    public function setCustomAttributeFilters($custom_attribute_filters)
    {
        $this->custom_attribute_filters = $custom_attribute_filters;
        return $this;
    }
    /**
     * Gets does_not_exist
     * @return string[]
     */
    public function getDoesNotExist()
    {
        return $this->does_not_exist;
    }
  
    /**
     * Sets does_not_exist
     * @param string[] $does_not_exist See [CatalogQueryFilteredItemsNullableAttribute](#type-catalogqueryfiltereditemsnullableattribute) for possible values
     * @return $this
     */
    public function setDoesNotExist($does_not_exist)
    {
        $this->does_not_exist = $does_not_exist;
        return $this;
    }
    /**
     * Gets sort_order
     * @return string
     */
    public function getSortOrder()
    {
        return $this->sort_order;
    }
  
    /**
     * Sets sort_order
     * @param string $sort_order See [SortOrder](#type-sortorder) for possible values
     * @return $this
     */
    public function setSortOrder($sort_order)
    {
        $this->sort_order = $sort_order;
        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset 
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->$offset);
    }
  
    /**
     * Gets offset.
     * @param  integer $offset Offset 
     * @return mixed 
     */
    public function offsetGet($offset)
    {
        return $this->$offset;
    }
  
    /**
     * Sets value based on offset.
     * @param  integer $offset Offset 
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        $this->$offset = $value;
    }
  
    /**
     * Unsets offset.
     * @param  integer $offset Offset 
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->$offset);
    }
  
    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        } else {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this));
        }
    }
}
